<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            if (!Schema::hasColumn('contacts', 'updated_by')) {
                $table->unsignedInteger('updated_by')->nullable()->after('created_by');
                $table->index('updated_by');
                // Add FK if users table exists and column not already constrained
                try {
                    $table->foreign('updated_by')->references('id')->on('users')->onDelete('set null');
                } catch (\Throwable $e) {
                    // Some DBs may already have the FK or not support this in ALTER context; ignore
                }
            }
        });
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            if (Schema::hasColumn('contacts', 'updated_by')) {
                try {
                    $table->dropForeign(['updated_by']);
                } catch (\Throwable $e) {
                    // ignore if FK not present
                }
                $table->dropIndex(['updated_by']);
                $table->dropColumn('updated_by');
            }
        });
    }
};

